/** @file   gfxid.h
 * @brief   ID-codes for certain graphics
 * @version $Revision: 1.13 $
 * @author  Tomi Lamminsaari
 */
 
namespace WeWantWar {


/** @class  GfxIdPair
 * @brief   Encapsulates both the combine UID and graphic UID.
 * @author  Tomi Lamminsaari
 */
class GfxIdPair
{
public:
  /** Constructor.
   * @param   aCombineUid       Uid of the combine.
   * @param   aGraphicUid       Uid of the graphic.
   */
  GfxIdPair( int aCombineUid, int aGraphicUid );
  
  /** Destructor.
   */
  ~GfxIdPair();
  
  /** Returns the combine uid.
   * @return  The combine uid.
   */
  int CombineUid() const;
  
  /** Returns the graphic uid.
   * @return  Graphic uid.
   */
  int GraphicUid() const;
  
private:
  /** The combine uid. */
  int iCombineUid;
  /** Graphic uid. */
  int iGraphicUid;
};


/** @class  GfxID
 * @brief   Encapsulates the id-codes of the Graphics Objects.
 * @author  Tomi Lamminsaari
 *
 * Most of the game graphics are stored in a single datastructure and they
 * can by found by their id-codes.
 */
class GfxId
{
public:

  ///
  /// Player related graphics
  /// =======================
  
  static const int KPlayerCrowbar = 0;
  static const int KPlayerRifle = 1;
  static const int KPlayerMinigun = 2;
  static const int KPlayerUzi = 3;
  static const int KPlayerLauncher = 4;
  
  
  ///
  /// Enemy related graphics
  /// ======================
  
  static const int KAlienCarnivore = 10;
  static const int KAlienSmallWorm = 20;
  static const int KAlienMediumWorm = 21;
  static const int KAlienWinged = 30;
  static const int KAlienWingedShadow = 31;
  static const int KAlienProctor = 50;
  static const int KAlienMinigun = 60;
  static const int KAlienPredator = 70;
  static const int KAlienFlamer = 80;
  static const int KAlienLightball = 90;
  static const int KAlienBlueBadAss = 91;
  static const int KAlienHiddenWorm = 92;
  static const int KAlienSlime = 93;
  
  static const int KAlienSentryGun1 = 300;
  static const int KAlienSentryGun2 = 301;
  static const int KAlienSentryGun3 = 302;
  static const int KAlienSentrySupport = 310;
  static const int KAlienStarGate = 311;
  static const int KAlienBigGun = 312;
  static const int KAlienBigGunSupport = 313;
  
  static const int KAlienFighter1 = 500;
  static const int KAlienFighter1Shadow = 501;
  static const int KAlienFighter2 = 502;
  static const int KAlienFighter2Shadow = 503;
  static const int KAlienGuardianTank = 504;
  
  
  ///
  /// Friendly objects
  /// ================
  static const int KCivilians1 = 1000;
  static const int KCivilians2 = 1001;
  static const int KCorpses = 1010;
  static const int KBonusImages = 1050;
  static const int KHudSymbols = 1051;
  
  
  ///
  /// Weapon related graphics
  /// =======================
  static const int KFlameThrowerFlame = 2000;
  static const int KFxBulletMotion = 2001;
  static const int KBulletShells = 2002;
  static const int KExplosionGrenade = 2003;
  static const int KRifleFlame = 2004;
  static const int KRifleLight = 2005;
  
  static const int KBulletAlienFireball = 2007;
  static const int KBulletCannonBall = 2008;
  static const int KAlienMines = 2009;
  static const int KPlayerGun = 2010;
  static const int KBulletRocketLauncher = 2011;
  static const int KFxRocketMotion = 2012;
  static const int KFxRocketLauncherLaunch = 2013;
  static const int KBulletMinigun = 2014;
  static const int KGrenadeGraphics = 2015;
  static const int KBulletAlienFireball2 = 2016;
  static const int KBulletMotion2 = 2017;
  
  ///
  /// Explosions and fire effects
  ///
  static const int KSmallExplosion = 3000;
  static const int KGrenadeExplosion = 3001;
  static const int KFxCampFire = 3050;
  static const int KForceField = 3051;
  static const int KExplosionLightRing = 3052;
  ///
  /// Misc. Graphics
  /// ==============
  static const int KDecorativeFountain = 6100;
  static const int KDecorativeMinihouse = 6101;
  static const int KBarrel = 6102;
  static const int KDecorativeChair1 = 6103;
  static const int KDecorativeLapTop = 6104;
  static const int KDecorativeMonitor = 6105;
  static const int KDecorativeMicrowave = 6106;
  static const int KBarrel2 = 6107;
  static const int KDecorativeChair2 = 6108;
  static const int KTextureBitmaps = 6109;
  static const int KDecorativeChair3 = 6110;
  static const int KDecorativeTelevision = 6111;
  
  ///
  /// Light and shadow graphics
  ///
  static const int KDynamicShadows = 4003;
  static const int KRifleShotLight = 4010;
  static const int KStreetLights = 4011;
  static const int KGrenadeLights = 4012;
  
  ///
  /// Effect graphics
  ///
  static const int KFxFraction = 6200;
  static const int KFxSewerplate1 = 6201;
  static const int KFxSewerplate2 = 6202;
  static const int KFxSewerplate3 = 6203;
  
  ///
  /// Gamepart HUD graphics
  ///
  static const int KHudTextures = 6001;
  static const int KHudCrosshair = 6002;
  static const int KHudScores = 6003;
  static const int KHudComboLabels = 6004;


  ///
  /// Menu backgrounds
  ///
  static const int KMenuSmallWindow = 7000;
  static const int KGameOverLabel = 7001;
  

};


};  // end of namespace

/**
 * Version history
 * ===============
 * $Log: gfxid.h,v $
 * Revision 1.13  2006/08/13 21:04:57  lamminsa
 * Game Over graphic added.
 *
 * Revision 1.12  2006/06/21 16:10:30  lamminsa
 * no message
 *
 * Revision 1.11  2006/06/03 15:51:03  lamminsa
 * Sewerplate 3 graphics added.
 *
 * Revision 1.10  2006/04/25 18:02:29  lamminsa
 * HiddenWormAlien, SlimeAlien, Fireball2 and BulletMotion2 added.
 *
 * Revision 1.9  2006/04/12 21:10:54  lamminsa
 * Badass alien graphics added.
 *
 * Revision 1.8  2006/04/03 20:54:39  lamminsa
 * Scores and combo graphics.
 *
 * Revision 1.7  2006/03/29 22:26:54  lamminsa
 * no message
 *
 * Revision 1.6  2006/03/16 21:09:07  lamminsa
 * Fighter graphics were added.
 *
 * Revision 1.5  2006/02/24 12:24:26  lamminsa
 * no message
 *
 * Revision 1.4  2006/02/17 23:09:00  lamminsa
 * no message
 *
 * Revision 1.3  2006/02/11 23:40:03  lamminsa
 * no message
 *
 * Revision 1.2  2006/02/08 22:03:28  lamminsa
 * New animation and graphic system was implemented.
 *
 * Revision 1.1.1.1  2006/01/21 23:02:41  lamminsa
 * no message
 *
 * Revision 1.4  2006-01-10 22:54:12+02  lamminsa
 * decorative_chair2 added
 *
 * Revision 1.3  2005-12-30 23:41:02+02  lamminsa
 * <>
 *
 * Revision 1.2  2005-11-23 00:25:37+02  lamminsa
 * <>
 *
 * Revision 1.1  2005-11-13 14:48:18+02  lamminsa
 * RocketLauncher, explosion and minigunbullet graphics were added.
 *
 */
 
